/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.block.CustomFarmBlock;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.mixin.FarmBlockAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class FertilizedFarmlandBlock
extends FarmBlock
implements CustomFarmBlock {
    private final List<FarmlandTrait> traits;

    public FertilizedFarmlandBlock(FarmlandTrait ... traits) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60918_(SoundType.f_56739_).m_60978_(0.6f).m_60977_());
        this.traits = Lists.newArrayList((Object[])traits);
    }

    public boolean canSustainPlant(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction, Block block) {
        return true;
    }

    public boolean isFertile(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return (Integer)state.m_61143_((Property)f_53243_) > 0;
    }

    public float getDoubleGrowthChance() {
        return (float)this.traits.stream().mapToDouble(FarmlandTrait::getDoubleGrowthChance).sum();
    }

    public float getBonusCropChance() {
        return (float)this.traits.stream().mapToDouble(FarmlandTrait::getBonusCropChance).sum();
    }

    public float getRegressionChance() {
        return (float)FarmingForBlockheadsConfig.getActive().fertilizerRegressionChance;
    }

    private boolean isStable() {
        return this.traits.stream().anyMatch(FarmlandTrait::isStable);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!this.isStable()) {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.m_61143_((Property)f_53243_);
        if (!FarmBlockAccessor.callIsNearWater((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (moisture > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!FarmBlockAccessor.callIsUnderCrops((BlockGetter)level, pos) && this.traits.stream().noneMatch(FarmlandTrait::isStable)) {
                FertilizedFarmlandBlock.m_53296_((BlockState)state, (Level)level, (BlockPos)pos);
            }
        } else if (moisture < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public Collection<FarmlandTrait> getTraits() {
        return this.traits;
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flag) {
        for (FarmlandTrait trait : this.traits) {
            MutableComponent traitComponent = Component.m_237115_((String)("tooltip.farmingforblockheads:trait_" + trait.getTraitName()));
            traitComponent.m_130940_(trait.getTraitColor());
            tooltip.add((Component)traitComponent);
        }
    }

    public static interface FarmlandTrait {
        default public float getDoubleGrowthChance() {
            return 0.0f;
        }

        default public float getBonusCropChance() {
            return 0.0f;
        }

        default public boolean isStable() {
            return false;
        }

        public String getTraitName();

        public ChatFormatting getTraitColor();
    }

    public static class FarmlandStableTrait
    implements FarmlandTrait {
        @Override
        public boolean isStable() {
            return true;
        }

        @Override
        public String getTraitName() {
            return "stable";
        }

        @Override
        public ChatFormatting getTraitColor() {
            return ChatFormatting.YELLOW;
        }
    }

    public static class FarmlandRichTrait
    implements FarmlandTrait {
        @Override
        public float getBonusCropChance() {
            return (float)FarmingForBlockheadsConfig.getActive().fertilizerBonusCropChance;
        }

        @Override
        public String getTraitName() {
            return "rich";
        }

        @Override
        public ChatFormatting getTraitColor() {
            return ChatFormatting.GREEN;
        }
    }

    public static class FarmlandHealthyTrait
    implements FarmlandTrait {
        @Override
        public float getDoubleGrowthChance() {
            return (float)FarmingForBlockheadsConfig.getActive().fertilizerBonusGrowthChance;
        }

        @Override
        public String getTraitName() {
            return "healthy";
        }

        @Override
        public ChatFormatting getTraitColor() {
            return ChatFormatting.DARK_RED;
        }
    }
}

